#include "interface.h"

// Initialise la SDL
void initialiser_affichage(SDL_Surface** fenetre,long largeur,long hauteur)
{
    char str[255];

    // On initialise la SDL
    if ( SDL_Init( SDL_INIT_VIDEO ) < 0 ) // Mode Video seulement pour le moment
    {
        printf( "Impossible d'initialiser la SDL: %s\n", SDL_GetError() );
        exit(EXIT_FAILURE);
    }

    // On initialise SDL_ttf
    if(TTF_Init() == -1)
    {
        printf("Erreur d'initialisation de TTF_Init : %s\n", TTF_GetError());
        exit(EXIT_FAILURE);
    }

    putenv("SDL_VIDEO_WINDOW_POS=center"); //pour centrer la fentre
    sprintf(str,"%s%s",RESSOURCES_DIR,"icon.png");
    SDL_WM_SetIcon(IMG_Load(str),NULL);

    // On cre la fenetre
    *fenetre = SDL_SetVideoMode(largeur,hauteur, BITSPERPIXEL,SDL_HWSURFACE);
    if (!*fenetre )
    {
        printf("Impossible d'afficher en %ldx%ld: %s\n",largeur,hauteur, SDL_GetError());
        exit(EXIT_FAILURE);
    }

    SDL_WM_SetCaption(TITRE, NULL); //On donne un titre  la fentre
    SDL_EnableUNICODE(1); // On active la saisie Unicode
    SDL_EnableKeyRepeat(250, 100); // On active la rptition des touches dlai 250ms, rptition 100ms
    SDL_ShowCursor(0);


    if (Mix_OpenAudio(48000, AUDIO_S16SYS, 2, 1024) < 0)
    {
        printf("Error initializing SDL_mixer: %s\n", Mix_GetError());
        exit(1);
    }

}

// Initialise l'interface et les elements du GUI
void initialiser_interface(t_interface* interface)
{
    long n; // compteur
    char str[255];
    str[0]=0;



    interface->accent=0;// Pas d'accent retenu en memoire
    sprintf(str,"%s%s",RESSOURCES_DIR,POLICE_TEXTE);
    interface->font = TTF_OpenFont(str, POLICE_TAILLE_NORMALE); // On charge la Police de caractre


    interface->gui_taille=69; // Nombre d'elements dans l'interface
    interface->gui=(t_gui_element**)malloc(interface->gui_taille*sizeof(t_gui_element*)); // On alloue la mmoire de ces lements
    interface->gui_actif = NULL;

    for (n=0;n<interface->gui_taille;n++)
    {
        interface->gui[n]=(t_gui_element*)malloc(interface->gui_taille*sizeof(t_gui_element)); // On alloue les lements
    }

/*
    DESIGN DU MENU
*/

n=0; /// ELEMENT 0 :  Arrire plan du Menu
    interface->gui[n]->type=IMAGE; // Element de type Image
    sprintf(str,"%s%s",RESSOURCES_DIR,"splash.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image du fond
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->valeur=NULL;// Pas de Texte
    interface->gui[n]->position.x=0; // On Positionne le fond dans le coin haut gauche
    interface->gui[n]->position.y=0;// En haut
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=0; // On ne rogne pas l'image
    interface->gui[n]->crop.h=0; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=FENETRE; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_IMAGE; // L'image sera libr  la fin

    interface->gui[n]->image->format->Amask=0;

/*
    MENU PRINCIPAL
*/

n++; /// ELEMENT 1 :  Fond du Menu Principal
    interface->gui[n]->type=IMAGE; // Element de type Image
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE|SDL_SRCALPHA,256,320,BITSPERPIXEL, 0,0,0,0);
    SDL_SetAlpha(interface->gui[n]->image, SDL_SRCALPHA, 128);
    SDL_FillRect(interface->gui[n]->image, 0, SDL_MapRGB(interface->fenetre->format, 255, 255, 255)); // On remplit le champ en gris
    interface->gui[n]->valeur=NULL;// Pas de Texte
    interface->gui[n]->position.x=interface->fenetre->w/2-(interface->gui[n]->image->w/2); // On Positionne le fond au milieu de la fenetre
    interface->gui[n]->position.y=224;// En haut
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=0; // On ne rogne pas l'image
    interface->gui[n]->crop.h=0; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=MENU_PRINCIPAL; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_IMAGE; // L'image sera libr  la fin

n++; /// ELEMENT 2 :  Titre "Menu Principal"
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("Menu Principal") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"Menu Principal"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[n-1]->position.x+4; // On le positionne  4 px du bord gauche du fond
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+4; // 4px du bord haut
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=MENU_PRINCIPAL; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 3 :  Bouton Rejoindre Partie
    interface->gui[n]->type=BOUTON; // Element de type Image
    sprintf(str,"%s%s",RESSOURCES_DIR,"bouton1.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image du bouton
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->valeur=(char*)malloc(strlen("Rejoindre une Partie")+1);// On alloue la taille du texte
    sprintf(interface->gui[n]->valeur,"Rejoindre une Partie");// On Dfinit le Texte
    interface->gui[n]->position.x=interface->fenetre->w/2-(interface->gui[n]->image->w/2); // On Positionne le bouton au milieu
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+32;// En haut du menu
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=160; // On ne rogne pas l'image
    interface->gui[n]->crop.h=32; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=MENU_PRINCIPAL; // Element du Menu Principal
    interface->gui[n]->flag=CONFIGURER_REJOINDRE; // On passe au Menu Rejoindre
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // L'image sera libr  la fin

n++; /// ELEMENT 4 :  Bouton Nouvelle Partie
    interface->gui[n]->type=BOUTON; // Element de type Image
    sprintf(str,"%s%s",RESSOURCES_DIR,"bouton1.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image du bouton
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->valeur=(char*)malloc(strlen("Nouvelle Partie")+1);// On alloue la taille du texte
    sprintf(interface->gui[n]->valeur,"Nouvelle Partie");// On Dfinit le Texte
    interface->gui[n]->position.x=interface->fenetre->w/2-(interface->gui[n]->image->w/2); // On Positionne le bouton au milieu
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+interface->gui[n-1]->crop.h+4;// En haut du menu
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=160; // On ne rogne pas l'image
    interface->gui[n]->crop.h=32; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=MENU_PRINCIPAL; // Element du Menu Principal
    interface->gui[n]->flag=CONFIGURER_SERVEUR; // On passe au Menu Rejoindre
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // L'image sera libr  la fin

n++; /// ELEMENT 5 :  Bouton Editeur de Maps
    interface->gui[n]->type=BOUTON; // Element de type Image
    sprintf(str,"%s%s",RESSOURCES_DIR,"bouton1.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image du bouton
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->valeur=(char*)malloc(strlen("Editeur de Maps")+1);// On alloue la taille du texte
    sprintf(interface->gui[n]->valeur,"Editeur de Maps");// On Dfinit le Texte
    interface->gui[n]->position.x=interface->fenetre->w/2-(interface->gui[n]->image->w/2); // On Positionne le bouton au milieu
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+interface->gui[n-1]->crop.h+4;// En haut du menu
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=160; // On ne rogne pas l'image
    interface->gui[n]->crop.h=32; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=MENU_PRINCIPAL; // Element du Menu Principal
    interface->gui[n]->flag=CONFIGURER_EDITEUR; // On passe au Menu Rejoindre
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // L'image sera libr  la fin

n++; /// ELEMENT 6 :  Bouton Options
    interface->gui[n]->type=BOUTON; // Element de type Image
    sprintf(str,"%s%s",RESSOURCES_DIR,"bouton1.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image du bouton
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->valeur=(char*)malloc(strlen("Options")+1);// On alloue la taille du texte
    sprintf(interface->gui[n]->valeur,"Options");// On Dfinit le Texte
    interface->gui[n]->position.x=interface->fenetre->w/2-(interface->gui[n]->image->w/2); // On Positionne le bouton au milieu
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+interface->gui[n-1]->crop.h+32;// En haut du menu
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=160; // On ne rogne pas l'image
    interface->gui[n]->crop.h=32; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=MENU_PRINCIPAL; // Element du Menu Principal
    interface->gui[n]->flag=CONFIGURER_OPTIONS; // On passe au Menu Rejoindre
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // L'image sera libr  la fin

n++; /// ELEMENT 7 :  Bouton de Credits : Ze Table Ronde
    interface->gui[n]->type=BOUTON; // Element de type Image
    sprintf(str,"%s%s",RESSOURCES_DIR,"bouton1.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image du bouton
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->valeur=(char*)malloc(strlen("Ze Table Ronde")+1);// On alloue la taille du texte
    sprintf(interface->gui[n]->valeur,"Ze Table Ronde");// On Dfinit le Texte
    interface->gui[n]->position.x=interface->fenetre->w/2-(interface->gui[n]->image->w/2); // On Positionne le bouton au milieu
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+interface->gui[n-1]->crop.h+4;// En haut du menu
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=160; // On ne rogne pas l'image
    interface->gui[n]->crop.h=32; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=MENU_PRINCIPAL; // Element du Menu Principal
    interface->gui[n]->flag=CREDITS; // On passe au Menu Rejoindre
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // L'image sera libr  la fin

n++; /// ELEMENT 8 :  Bouton Quitter
    interface->gui[n]->type=BOUTON; // Element de type Image
    sprintf(str,"%s%s",RESSOURCES_DIR,"bouton1.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image du bouton
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->valeur=(char*)malloc(strlen("Quitter le Jeu")+1);// On alloue la taille du texte
    sprintf(interface->gui[n]->valeur,"Quitter le Jeu");// On Dfinit le Texte
    interface->gui[n]->position.x=interface->fenetre->w/2-(interface->gui[n]->image->w/2); // On Positionne le bouton au milieu
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+interface->gui[n-1]->crop.h+32;// En haut du menu
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=160; // On ne rogne pas l'image
    interface->gui[n]->crop.h=32; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=MENU_PRINCIPAL; // Element du Menu Principal
    interface->gui[n]->flag=QUITTER; // On passe au Menu Rejoindre
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // L'image sera libr  la fin

/*
    MENU REJOINDRE
*/

n++; /// ELEMENT 9 :  Fond du Menu Rejoindre
    interface->gui[n]->type=IMAGE; // Element de type Image
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE|SDL_SRCALPHA,480,192,BITSPERPIXEL, 0,0,0,0);
    SDL_SetAlpha(interface->gui[n]->image, SDL_SRCALPHA, 128);
    SDL_FillRect(interface->gui[n]->image, 0, SDL_MapRGB(interface->fenetre->format, 255,255,255)); // On remplit le champ en gris
    interface->gui[n]->valeur=NULL;// Pas de Texte
    interface->gui[n]->position.x=interface->fenetre->w/2-(interface->gui[n]->image->w/2); // On Positionne le fond au milieu de la fenetre
    interface->gui[n]->position.y=224;// En haut
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=0; // On ne rogne pas l'image
    interface->gui[n]->crop.h=0; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_REJOINDRE; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_IMAGE; // L'image sera libr  la fin

n++; /// ELEMENT 10 :  Titre "Rejoindre une Partie"
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("Rejoindre une Partie") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"Rejoindre une Partie"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[n-1]->position.x+4; // On le positionne  4 px du bord gauche du fond
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+4; // 4px du bord haut
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_REJOINDRE; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 11 :  Label Pseudo
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("Pseudo :") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"Pseudo :"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[n-1]->position.x+16; // On le positionne  4 px du bord gauche du fond
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+32; // 4px du bord haut
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_REJOINDRE; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 12 :  Saisie du Pseudo
    interface->gui[n]->type=SAISIE; // Element de type Saisie
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE,256,32,BITSPERPIXEL, 0,0,0,0);// On cre la surface du champ
    SDL_FillRect(interface->gui[n]->image, 0, SDL_MapRGB(interface->fenetre->format, 255, 255, 255)); // On remplit le champ en blanc
    interface->gui[n]->valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n]->valeur[0]=0;
    strcpy(interface->gui[n]->valeur,interface->options.pseudo);
    interface->gui[n]->position.x=interface->gui[n-1]->position.x; // Position en X du champ
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+24; // Position en Y du champ
    interface->gui[n]->crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.w=256; // Largeur de 160
    interface->gui[n]->crop.h=24;  // Hauteur de 24
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_REJOINDRE; // Element du Menu Principal
    interface->gui[n]->flag=REJOINDRE_PSEUDO; // Pas d'action lors de sa validation
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 13 :  Label Port du Serveur
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("Port du Serveur :") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"Port du Serveur :"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[n-1]->position.x+interface->gui[n-1]->crop.w+56; // On le positionne  4 px du bord gauche du fond
    interface->gui[n]->position.y=interface->gui[n-2]->position.y; // 4px du bord haut
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_REJOINDRE; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 14 :  Saisie du Port du Serveur
    interface->gui[n]->type=SAISIE; // Element de type Saisie
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE,128,32,BITSPERPIXEL, 0,0,0,0);// On cre la surface du champ
    SDL_FillRect(interface->gui[n]->image, 0, SDL_MapRGB(interface->fenetre->format, 255, 255, 255)); // On remplit le champ en blanc
    interface->gui[n]->valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n]->valeur[0]=0;
    interface->gui[n]->position.x=interface->gui[n-1]->position.x; // Position en X du champ
    interface->gui[n]->position.y=interface->gui[n-2]->position.y; // Position en Y du champ
    interface->gui[n]->crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.w=128; // Largeur de 160
    interface->gui[n]->crop.h=24;  // Hauteur de 24
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_REJOINDRE; // Element du Menu Principal
    interface->gui[n]->flag=REJOINDRE_PORT; // Pas d'action lors de sa validation
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 15 :  Label Adresse du Serveur
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("Adresse du Serveur :") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"Adresse du Serveur :"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[n-3]->position.x; // On le positionne  4 px du bord gauche du fond
    interface->gui[n]->position.y=interface->gui[n-3]->position.y+32; // 4px du bord haut
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_REJOINDRE; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 16 :  Saisie de l'Adresse du Serveur
    interface->gui[n]->type=SAISIE; // Element de type Saisie
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE,440,32,BITSPERPIXEL, 0,0,0,0);// On cre la surface du champ
    SDL_FillRect(interface->gui[n]->image, 0, SDL_MapRGB(interface->fenetre->format, 255, 255, 255)); // On remplit le champ en blanc
    interface->gui[n]->valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n]->valeur[0]=0;
    interface->gui[n]->position.x=interface->gui[n-1]->position.x; // Position en X du champ
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+24; // Position en Y du champ
    interface->gui[n]->crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.w=440; // Largeur de 160
    interface->gui[n]->crop.h=24;  // Hauteur de 24
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_REJOINDRE; // Element du Menu Principal
    interface->gui[n]->flag=REJOINDRE_ADRESSE; // Pas d'action lors de sa validation
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 17 :  Bouton Rejoindre la Partie
    interface->gui[n]->type=BOUTON; // Element de type Image
    sprintf(str,"%s%s",RESSOURCES_DIR,"bouton1.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image du bouton
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->valeur=(char*)malloc(strlen("Rejoindre")+1);// On alloue la taille du texte
    sprintf(interface->gui[n]->valeur,"Rejoindre");// On Dfinit le Texte
    interface->gui[n]->position.x=476; // On Positionne le bouton au milieu
    interface->gui[n]->position.y=380;// En haut du menu
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=160; // On ne rogne pas l'image
    interface->gui[n]->crop.h=32; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_REJOINDRE; // Element du Menu Principal
    interface->gui[n]->flag=REJOINDRE; // On passe au Menu Rejoindre
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // L'image sera libr  la fin

n++; /// ELEMENT 18 :  Bouton Retour au Menu
    interface->gui[n]->type=BOUTON; // Element de type Image
    sprintf(str,"%s%s",RESSOURCES_DIR,"bouton1.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image du bouton
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->valeur=(char*)malloc(strlen("Retour au Menu")+1);// On alloue la taille du texte
    sprintf(interface->gui[n]->valeur,"Retour au Menu");// On Dfinit le Texte
    interface->gui[n]->position.x=164; // On Positionne le bouton au milieu
    interface->gui[n]->position.y=380;// En haut du menu
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=160; // On ne rogne pas l'image
    interface->gui[n]->crop.h=32; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_REJOINDRE; // Element du Menu Principal
    interface->gui[n]->flag=RETOUR; // On passe au Menu Rejoindre
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // L'image sera libre  la fin

/*
    MENU NOUVELLE PARTIE
*/

n++; /// ELEMENT 19 :  Fond du Menu Nouvelle Partie
    interface->gui[n]->type=IMAGE; // Element de type Image
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE|SDL_SRCALPHA,420,320,BITSPERPIXEL, 0,0,0,0);
    SDL_SetAlpha(interface->gui[n]->image, SDL_SRCALPHA, 128);
    SDL_FillRect(interface->gui[n]->image, 0, SDL_MapRGB(interface->fenetre->format, 255,255,255)); // On remplit le champ en gris
    interface->gui[n]->valeur=NULL;// Pas de Texte
    interface->gui[n]->position.x=interface->fenetre->w/2-(interface->gui[n]->image->w/2); // On Positionne le fond au milieu de la fenetre
    interface->gui[n]->position.y=224;// En haut
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=0; // On ne rogne pas l'image
    interface->gui[n]->crop.h=0; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_SERVEUR; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_IMAGE; // L'image sera libr  la fin

n++; /// ELEMENT 20 :  Titre "Nouvelle Partie"
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("Nouvelle Partie") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"Nouvelle Partie"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[n-1]->position.x+4; // On le positionne  4 px du bord gauche du fond
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+4; // 4px du bord haut
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_SERVEUR; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 21 :  Label Charger la Partie
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("Charger la Partie :") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"Charger la Partie :"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[n-1]->position.x+16; // On le positionne  4 px du bord gauche du fond
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+32; // 4px du bord haut
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_SERVEUR; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 22 :  Saisie du Nom de la Partie
    interface->gui[n]->type=SAISIE; // Element de type Saisie
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE,216,24,BITSPERPIXEL, 0,0,0,0);// On cre la surface du champ
    SDL_FillRect(interface->gui[n]->image, 0, SDL_MapRGB(interface->fenetre->format, 255, 255, 255)); // On remplit le champ en blanc
    interface->gui[n]->valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n]->valeur[0]=0;
    interface->gui[n]->position.x=interface->gui[n-1]->position.x + 128; // Position en X du champ
    interface->gui[n]->position.y=interface->gui[n-1]->position.y; // Position en Y du champ
    interface->gui[n]->crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.w=216; // Largeur de 160
    interface->gui[n]->crop.h=24;  // Hauteur de 24
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_SERVEUR; // Element du Menu Principal
    interface->gui[n]->flag=PARTIE_NOM; // Pas d'action lors de sa validation
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 23 :  Remarque sur le chargement de partie
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("Remarque: \"autosave.kjeu\" permet de rcuprer une partie") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"Remarque: \"autosave.kjeu\" permet de rcuprer une partie"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[n-2]->position.x; // On le positionne  4 px du bord gauche du fond
    interface->gui[n]->position.y=interface->gui[n-2]->position.y+24; // 4px du bord haut
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_SERVEUR; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 24 :  Ligne Horizontale
    interface->gui[n]->type=IMAGE; // Element de type Saisie
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE,380,1,BITSPERPIXEL, 0,0,0,0);// On cre la surface du champ
    SDL_FillRect(interface->gui[n]->image, 0, SDL_MapRGB(interface->fenetre->format, 0,0,0)); // On remplit le champ en blanc
    interface->gui[n]->valeur=NULL;
    interface->gui[n]->position.x=interface->gui[n-1]->position.x; // Position en X du champ
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+24; // Position en Y du champ
    interface->gui[n]->crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.w=380; // Largeur de 160
    interface->gui[n]->crop.h=1;  // Hauteur de 24
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_SERVEUR; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action lors de sa validation
    interface->gui[n]->free=FREE_IMAGE; // On libre l'image et le texte

n++; /// ELEMENT 25 :  Label Nom de la Map
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("Nom de la Map :") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"Nom de la Map :"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[n-1]->position.x; // On le positionne  4 px du bord gauche du fond
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+4; // 4px du bord haut
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_SERVEUR; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 26 :  Saisie du Nom de la Map
    interface->gui[n]->type=SAISIE; // Element de type Saisie
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE,216,24,BITSPERPIXEL, 0,0,0,0);// On cre la surface du champ
    SDL_FillRect(interface->gui[n]->image, 0, SDL_MapRGB(interface->fenetre->format, 255, 255, 255)); // On remplit le champ en blanc
    interface->gui[n]->valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n]->valeur[0]=0;
    interface->gui[n]->position.x=interface->gui[n-1]->position.x + 128; // Position en X du champ
    interface->gui[n]->position.y=interface->gui[n-1]->position.y; // Position en Y du champ
    interface->gui[n]->crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.w=216; // Largeur de 160
    interface->gui[n]->crop.h=24;  // Hauteur de 24
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_SERVEUR; // Element du Menu Principal
    interface->gui[n]->flag=PARTIE_MAP; // Pas d'action lors de sa validation
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 27 :  Label Visibilit
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("Distance de Visibilit :") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"Distance de Visibilit :"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[n-2]->position.x; // On le positionne  4 px du bord gauche du fond
    interface->gui[n]->position.y=interface->gui[n-2]->position.y+28; // 4px du bord haut
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_SERVEUR; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 28 :  Saisie de la Visibilit
    interface->gui[n]->type=SAISIE; // Element de type Saisie
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE,96,24,BITSPERPIXEL, 0,0,0,0);// On cre la surface du champ
    SDL_FillRect(interface->gui[n]->image, 0, SDL_MapRGB(interface->fenetre->format, 255, 255, 255)); // On remplit le champ en blanc
    interface->gui[n]->valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n]->valeur[0]=0;
    interface->gui[n]->position.x=interface->gui[n-1]->position.x; // Position en X du champ
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+24; // Position en Y du champ
    interface->gui[n]->crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.w=96; // Largeur de 160
    interface->gui[n]->crop.h=24;  // Hauteur de 24
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_SERVEUR; // Element du Menu Principal
    interface->gui[n]->flag=PARTIE_DIST_VIS; // Pas d'action lors de sa validation
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 29 :  Valeur de la Visibilit par Dfaut
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("(Dfaut: 2)") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"(Dfaut: 2)"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[n-1]->position.x+interface->gui[n-1]->crop.w+4; // On le positionne  4 px du bord gauche du fond
    interface->gui[n]->position.y=interface->gui[n-1]->position.y; // 4px du bord haut
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_SERVEUR; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 30 :  Label Exploration
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("Distance d'Exploration :") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"Distance d'Exploration :"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[n-3]->position.x+210; // On le positionne  4 px du bord gauche du fond
    interface->gui[n]->position.y=interface->gui[n-3]->position.y; // 4px du bord haut
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_SERVEUR; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 31 :  Saisie de l'Exploration
    interface->gui[n]->type=SAISIE; // Element de type Saisie
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE,96,24,BITSPERPIXEL, 0,0,0,0);// On cre la surface du champ
    SDL_FillRect(interface->gui[n]->image, 0, SDL_MapRGB(interface->fenetre->format, 255, 255, 255)); // On remplit le champ en blanc
    interface->gui[n]->valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n]->valeur[0]=0;
    interface->gui[n]->position.x=interface->gui[n-3]->position.x+210; // Position en X du champ
    interface->gui[n]->position.y=interface->gui[n-3]->position.y; // Position en Y du champ
    interface->gui[n]->crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.w=96; // Largeur de 160
    interface->gui[n]->crop.h=24;  // Hauteur de 24
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_SERVEUR; // Element du Menu Principal
    interface->gui[n]->flag=PARTIE_DIST_INC; // Pas d'action lors de sa validation
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 32 :  Valeur de l'Exploration par Dfaut
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("(Dfaut: 1)") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"(Dfaut: 1)"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[n-1]->position.x+interface->gui[n-1]->crop.w+4; // On le positionne  4 px du bord gauche du fond
    interface->gui[n]->position.y=interface->gui[n-1]->position.y; // 4px du bord haut
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_SERVEUR; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 33 :  Label Nombre de Pions
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("Nombre de pions:") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"Nombre de pions:"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[n-5]->position.x; // On le positionne  4 px du bord gauche du fond
    interface->gui[n]->position.y=interface->gui[n-5]->position.y+28; // 4px du bord haut
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_SERVEUR; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 34 :  Label Chevaliers
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("Chevaliers :") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"Chevaliers :"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[n-1]->position.x+64; // On le positionne  4 px du bord gauche du fond
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+24; // 4px du bord haut
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_SERVEUR; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 35 :  Saisie du Nombre de Chevaliers
    interface->gui[n]->type=SAISIE; // Element de type Saisie
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE,96,24,BITSPERPIXEL, 0,0,0,0);// On cre la surface du champ
    SDL_FillRect(interface->gui[n]->image, 0, SDL_MapRGB(interface->fenetre->format, 255, 255, 255)); // On remplit le champ en blanc
    interface->gui[n]->valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n]->valeur[0]=0;
    interface->gui[n]->position.x=interface->gui[n-1]->position.x + 96; // Position en X du champ
    interface->gui[n]->position.y=interface->gui[n-1]->position.y; // Position en Y du champ
    interface->gui[n]->crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.w=96; // Largeur de 160
    interface->gui[n]->crop.h=24;  // Hauteur de 24
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_SERVEUR; // Element du Menu Principal
    interface->gui[n]->flag=PARTIE_CHEVALIER; // Pas d'action lors de sa validation
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 36 :  Label Pcores
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("Pcores :") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"Pcores :"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[n-2]->position.x; // On le positionne  4 px du bord gauche du fond
    interface->gui[n]->position.y=interface->gui[n-2]->position.y+26; // 4px du bord haut
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_SERVEUR; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 37 :  Saisie du Nombre de Pcores
    interface->gui[n]->type=SAISIE; // Element de type Saisie
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE,96,24,BITSPERPIXEL, 0,0,0,0);// On cre la surface du champ
    SDL_FillRect(interface->gui[n]->image, 0, SDL_MapRGB(interface->fenetre->format, 255, 255, 255)); // On remplit le champ en blanc
    interface->gui[n]->valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n]->valeur[0]=0;
    interface->gui[n]->position.x=interface->gui[n-1]->position.x + 96; // Position en X du champ
    interface->gui[n]->position.y=interface->gui[n-1]->position.y; // Position en Y du champ
    interface->gui[n]->crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.w=96; // Largeur de 160
    interface->gui[n]->crop.h=24;  // Hauteur de 24
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_SERVEUR; // Element du Menu Principal
    interface->gui[n]->flag=PARTIE_PECORE; // Pas d'action lors de sa validation
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 38 :  Label Eclaireurs
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("Eclaireurs :") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"Eclaireurs :"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[n-2]->position.x; // On le positionne  4 px du bord gauche du fond
    interface->gui[n]->position.y=interface->gui[n-2]->position.y+26; // 4px du bord haut
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_SERVEUR; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 39 :  Saisie du Nombre d'Eclaireurs
    interface->gui[n]->type=SAISIE; // Element de type Saisie
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE,96,24,BITSPERPIXEL, 0,0,0,0);// On cre la surface du champ
    SDL_FillRect(interface->gui[n]->image, 0, SDL_MapRGB(interface->fenetre->format, 255, 255, 255)); // On remplit le champ en blanc
    interface->gui[n]->valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n]->valeur[0]=0;
    interface->gui[n]->position.x=interface->gui[n-1]->position.x + 96; // Position en X du champ
    interface->gui[n]->position.y=interface->gui[n-1]->position.y; // Position en Y du champ
    interface->gui[n]->crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.w=96; // Largeur de 160
    interface->gui[n]->crop.h=24;  // Hauteur de 24
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_SERVEUR; // Element du Menu Principal
    interface->gui[n]->flag=PARTIE_ECLAIREUR; // Pas d'action lors de sa validation
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 40 :  Bouton Lancer la Partie
    interface->gui[n]->type=BOUTON; // Element de type Image
    sprintf(str,"%s%s",RESSOURCES_DIR,"bouton1.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image du bouton
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->valeur=(char*)malloc(strlen("Lancer la Partie")+1);// On alloue la taille du texte
    sprintf(interface->gui[n]->valeur,"Lancer la Partie");// On Dfinit le Texte
    interface->gui[n]->position.x=(interface->fenetre->w / 2)+32 ;
    interface->gui[n]->position.y=interface->gui[n-1]->position.y + 32;
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=160; // On ne rogne pas l'image
    interface->gui[n]->crop.h=32; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_SERVEUR; // Element du Menu Principal
    interface->gui[n]->flag=SERVEUR; // On passe au Menu Rejoindre
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // L'image sera libr  la fin

n++; /// ELEMENT 41 :  Bouton Retour au Menu
    interface->gui[n]->type=BOUTON; // Element de type Image
    sprintf(str,"%s%s",RESSOURCES_DIR,"bouton1.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image du bouton
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->valeur=(char*)malloc(strlen("Retour au Menu")+1);// On alloue la taille du texte
    sprintf(interface->gui[n]->valeur,"Retour au Menu");// On Dfinit le Texte
    interface->gui[n]->position.x=(interface->fenetre->w / 2)-(interface->gui[n]->image->w + 32) ;
    interface->gui[n]->position.y=interface->gui[n-1]->position.y;
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=160; // On ne rogne pas l'image
    interface->gui[n]->crop.h=32; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_SERVEUR; // Element du Menu Principal
    interface->gui[n]->flag=RETOUR; // On passe au Menu Rejoindre
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // L'image sera libre  la fin

/*
    MENU EDITEUR
*/

n++; /// ELEMENT 42 :  Fond du Menu Editeur
    interface->gui[n]->type=IMAGE; // Element de type Image
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE|SDL_SRCALPHA,256,320,BITSPERPIXEL, 0,0,0,0);
    SDL_SetAlpha(interface->gui[n]->image, SDL_SRCALPHA, 128);
    SDL_FillRect(interface->gui[n]->image, 0, SDL_MapRGB(interface->fenetre->format, 255,255,255)); // On remplit le champ en gris
    interface->gui[n]->valeur=NULL;// Pas de Texte
    interface->gui[n]->position.x=interface->fenetre->w/2-(interface->gui[n]->image->w/2); // On Positionne le fond au milieu de la fenetre
    interface->gui[n]->position.y=224;// En haut
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=0; // On ne rogne pas l'image
    interface->gui[n]->crop.h=0; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_EDITEUR; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_IMAGE; // L'image sera libr  la fin

n++; /// ELEMENT 43 :  Titre "Editeur de Maps"
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("Editeur de Maps") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"Editeur de Maps"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[n-1]->position.x+4; // On le positionne  4 px du bord gauche du fond
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+4; // 4px du bord haut
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_EDITEUR; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 44 :  Label Nom de la Map
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("Nom de la Map :") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"Nom de la Map :"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[n-1]->position.x+16; // On le positionne  4 px du bord gauche du fond
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+32; // 4px du bord haut
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_EDITEUR; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 45 :  Saisie du Nom de la Map
    interface->gui[n]->type=SAISIE; // Element de type Saisie
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE,216,24,BITSPERPIXEL, 0,0,0,0);// On cre la surface du champ
    SDL_FillRect(interface->gui[n]->image, 0, SDL_MapRGB(interface->fenetre->format, 255, 255, 255)); // On remplit le champ en blanc
    interface->gui[n]->valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n]->valeur[0]=0;
    interface->gui[n]->position.x=interface->gui[n-1]->position.x; // Position en X du champ
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+24; // Position en Y du champ
    interface->gui[n]->crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.w=216; // Largeur de 160
    interface->gui[n]->crop.h=24;  // Hauteur de 24
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_EDITEUR; // Element du Menu Principal
    interface->gui[n]->flag=MAP_NOM; // Pas d'action lors de sa validation
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 46 :  Label Nom du Tileset
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("Nom du Tileset :") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"Nom du Tileset :"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[n-1]->position.x; // On le positionne  4 px du bord gauche du fond
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+32; // 4px du bord haut
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_EDITEUR; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 47 :  Saisie du Nom du Tileset
    interface->gui[n]->type=SAISIE; // Element de type Saisie
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE,216,24,BITSPERPIXEL, 0,0,0,0);// On cre la surface du champ
    SDL_FillRect(interface->gui[n]->image, 0, SDL_MapRGB(interface->fenetre->format, 255, 255, 255)); // On remplit le champ en blanc
    interface->gui[n]->valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n]->valeur[0]=0;
    interface->gui[n]->position.x=interface->gui[n-1]->position.x; // Position en X du champ
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+24; // Position en Y du champ
    interface->gui[n]->crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.w=216; // Largeur de 160
    interface->gui[n]->crop.h=24;  // Hauteur de 24
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_EDITEUR; // Element du Menu Principal
    interface->gui[n]->flag=MAP_TILESET; // Pas d'action lors de sa validation
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 48 :  Label Largeur
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("Largeur :") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"Largeur :"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[n-1]->position.x; // On le positionne  4 px du bord gauche du fond
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+32; // 4px du bord haut
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_EDITEUR; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 49 :  Saisie de la Largeur
    interface->gui[n]->type=SAISIE; // Element de type Saisie
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE,96,24,BITSPERPIXEL, 0,0,0,0);// On cre la surface du champ
    SDL_FillRect(interface->gui[n]->image, 0, SDL_MapRGB(interface->fenetre->format, 255, 255, 255)); // On remplit le champ en blanc
    interface->gui[n]->valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n]->valeur[0]=0;
    interface->gui[n]->position.x=interface->gui[n-1]->position.x; // Position en X du champ
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+24; // Position en Y du champ
    interface->gui[n]->crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.w=96; // Largeur de 160
    interface->gui[n]->crop.h=24;  // Hauteur de 24
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_EDITEUR; // Element du Menu Principal
    interface->gui[n]->flag=MAP_LARGEUR; // Pas d'action lors de sa validation
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 50 :  Label Hauteur
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("Hauteur :") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"Hauteur :"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[n-2]->position.x+120; // On le positionne  4 px du bord gauche du fond
    interface->gui[n]->position.y=interface->gui[n-2]->position.y; // 4px du bord haut
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_EDITEUR; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 51 :  Saisie de la Hauteur
    interface->gui[n]->type=SAISIE; // Element de type Saisie
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE,96,24,BITSPERPIXEL, 0,0,0,0);// On cre la surface du champ
    SDL_FillRect(interface->gui[n]->image, 0, SDL_MapRGB(interface->fenetre->format, 255, 255, 255)); // On remplit le champ en blanc
    interface->gui[n]->valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n]->valeur[0]=0;
    interface->gui[n]->position.x=interface->gui[n-2]->position.x+120; // Position en X du champ
    interface->gui[n]->position.y=interface->gui[n-2]->position.y; // Position en Y du champ
    interface->gui[n]->crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.w=96; // Largeur de 160
    interface->gui[n]->crop.h=24;  // Hauteur de 24
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_EDITEUR; // Element du Menu Principal
    interface->gui[n]->flag=MAP_HAUTEUR; // Pas d'action lors de sa validation
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 52 :  Bouton Lancer l'editeur
    interface->gui[n]->type=BOUTON; // Element de type Image
    sprintf(str,"%s%s",RESSOURCES_DIR,"bouton1.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image du bouton
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->valeur=(char*)malloc(strlen("Lancer l'diteur")+1);// On alloue la taille du texte
    sprintf(interface->gui[n]->valeur,"Lancer l'diteur");// On Dfinit le Texte
    interface->gui[n]->position.x=(interface->fenetre->w / 2)-(interface->gui[n]->image->w/2) ;
    interface->gui[n]->position.y=interface->gui[n-1]->position.y + 48;
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=160; // On ne rogne pas l'image
    interface->gui[n]->crop.h=32; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_EDITEUR; // Element du Menu Principal
    interface->gui[n]->flag=EDITEUR; // On passe au Menu Rejoindre
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // L'image sera libr  la fin

n++; /// ELEMENT 53 :  Bouton Retour au Menu
    interface->gui[n]->type=BOUTON; // Element de type Image
    sprintf(str,"%s%s",RESSOURCES_DIR,"bouton1.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image du bouton
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->valeur=(char*)malloc(strlen("Retour au Menu")+1);// On alloue la taille du texte
    sprintf(interface->gui[n]->valeur,"Retour au Menu");// On Dfinit le Texte
    interface->gui[n]->position.x=(interface->fenetre->w / 2)-(interface->gui[n]->image->w/2) ;
    interface->gui[n]->position.y=interface->gui[n-1]->position.y + 64;
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=160; // On ne rogne pas l'image
    interface->gui[n]->crop.h=32; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_EDITEUR; // Element du Menu Principal
    interface->gui[n]->flag=RETOUR; // On passe au Menu Rejoindre
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // L'image sera libre  la fin

/*
    MENU OPTIONS
*/

n++; /// ELEMENT 54 :  Fond du Menu Options
    interface->gui[n]->type=IMAGE; // Element de type Image
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE|SDL_SRCALPHA,256,320,BITSPERPIXEL, 0,0,0,0);
    SDL_SetAlpha(interface->gui[n]->image, SDL_SRCALPHA, 128);
    SDL_FillRect(interface->gui[n]->image, 0, SDL_MapRGB(interface->fenetre->format, 255,255,255)); // On remplit le champ en gris
    interface->gui[n]->valeur=NULL;// Pas de Texte
    interface->gui[n]->position.x=interface->fenetre->w/2-(interface->gui[n]->image->w/2); // On Positionne le fond au milieu de la fenetre
    interface->gui[n]->position.y=224;// En haut
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=0; // On ne rogne pas l'image
    interface->gui[n]->crop.h=0; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_OPTIONS; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_IMAGE; // L'image sera libr  la fin

n++; /// ELEMENT 55 :  Titre "Options"
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("Options") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"Options"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[n-1]->position.x+4; // On le positionne  4 px du bord gauche du fond
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+4; // 4px du bord haut
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_OPTIONS; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 56 :  Label Pseudo
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("Pseudo :") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"Pseudo :"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[n-1]->position.x+16; // On le positionne  4 px du bord gauche du fond
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+32; // 4px du bord haut
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_OPTIONS; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 57 :  Saisie du Pseudo
    interface->gui[n]->type=SAISIE; // Element de type Saisie
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE,216,24,BITSPERPIXEL, 0,0,0,0);// On cre la surface du champ
    SDL_FillRect(interface->gui[n]->image, 0, SDL_MapRGB(interface->fenetre->format, 255, 255, 255)); // On remplit le champ en blanc
    interface->gui[n]->valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n]->valeur[0]=0;
    strcpy(interface->gui[n]->valeur,interface->options.pseudo);
    interface->gui[n]->position.x=interface->gui[n-1]->position.x; // Position en X du champ
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+24; // Position en Y du champ
    interface->gui[n]->crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.w=256; // Largeur de 160
    interface->gui[n]->crop.h=24;  // Hauteur de 24
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_OPTIONS; // Element du Menu Principal
    interface->gui[n]->flag=PSEUDO; // Pas d'action lors de sa validation
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 58 :  Label Volume du Son
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("Volume du Son") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"Volume du Son"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[n-1]->position.x; // On le positionne  4 px du bord gauche du fond
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+32; // 4px du bord haut
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_OPTIONS; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 59 :  Saisie du Volume du Son
    interface->gui[n]->type=SAISIE; // Element de type Saisie
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE,96,24,BITSPERPIXEL, 0,0,0,0);// On cre la surface du champ
    SDL_FillRect(interface->gui[n]->image, 0, SDL_MapRGB(interface->fenetre->format, 255, 255, 255)); // On remplit le champ en blanc
    interface->gui[n]->valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n]->valeur[0]=0;
    sprintf(interface->gui[n]->valeur,"%ld",interface->options.volume_son);
    interface->gui[n]->position.x=interface->gui[n-1]->position.x; // Position en X du champ
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+24; // Position en Y du champ
    interface->gui[n]->crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.w=96; // Largeur de 160
    interface->gui[n]->crop.h=24;  // Hauteur de 24
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_OPTIONS; // Element du Menu Principal
    interface->gui[n]->flag=VOLUME_SON; // Pas d'action lors de sa validation
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 60 :  Label Volume de la Musique
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("Volume Musique") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"Volume Musique"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[n-2]->position.x+120; // On le positionne  4 px du bord gauche du fond
    interface->gui[n]->position.y=interface->gui[n-2]->position.y; // 4px du bord haut
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_OPTIONS; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 61 :  Saisie du Volume de la Musique
    interface->gui[n]->type=SAISIE; // Element de type Saisie
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE,96,24,BITSPERPIXEL, 0,0,0,0);// On cre la surface du champ
    SDL_FillRect(interface->gui[n]->image, 0, SDL_MapRGB(interface->fenetre->format, 255, 255, 255)); // On remplit le champ en blanc
    interface->gui[n]->valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n]->valeur[0]=0;
    sprintf(interface->gui[n]->valeur,"%ld",interface->options.volume_musique);
    interface->gui[n]->position.x=interface->gui[n-2]->position.x+120; // Position en X du champ
    interface->gui[n]->position.y=interface->gui[n-2]->position.y; // Position en Y du champ
    interface->gui[n]->crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.w=96; // Largeur de 160
    interface->gui[n]->crop.h=24;  // Hauteur de 24
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_OPTIONS; // Element du Menu Principal
    interface->gui[n]->flag=VOLUME_MUSIQUE; // Pas d'action lors de sa validation
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 62 :  Checkbox Plein Ecran
    interface->gui[n]->type=SWITCH; // Element de type Image
    sprintf(str,"%s%s",RESSOURCES_DIR,"switch2.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image du bouton
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->valeur=NULL;// On alloue la taille du texte
    interface->gui[n]->position.x=(interface->fenetre->w / 2)-(interface->gui[n]->image->w/2) - 96 ;
    interface->gui[n]->position.y=interface->gui[n-1]->position.y + 48;
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=32; // On ne rogne pas l'image
    interface->gui[n]->crop.h=32; // On ne rogne pas l'image
    if (interface->options.plein_ecran)
    {
        interface->gui[n]->etat=ACTIF; // On initialise son tat  ACTIF
    }
    else
    {
        interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    }
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_OPTIONS; // Element du Menu Principal
    interface->gui[n]->flag=PLEIN_ECRAN; // On passe au Menu Rejoindre
    interface->gui[n]->free=FREE_IMAGE; // L'image sera libr  la fin

n++; /// ELEMENT 63 :  Label Plein Ecran
    interface->gui[n]->type=TEXTE; // Element de type Image
    interface->gui[n]->image=NULL;
    interface->gui[n]->valeur=(char*)malloc(strlen("Plein Ecran")+1);// On alloue la taille du texte
    sprintf(interface->gui[n]->valeur,"Plein Ecran");// On Dfinit le Texte
    interface->gui[n]->position.x=interface->gui[n-1]->position.x + 48 ;
    interface->gui[n]->position.y=interface->gui[n-1]->position.y + 4;
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=32; // On ne rogne pas l'image
    interface->gui[n]->crop.h=32; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_OPTIONS; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // On passe au Menu Rejoindre
    interface->gui[n]->free=FREE_IMAGE; // L'image sera libr  la fin

n++; /// ELEMENT 64 :  Bouton Valider les Options
    interface->gui[n]->type=BOUTON; // Element de type Image
    sprintf(str,"%s%s",RESSOURCES_DIR,"bouton1.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image du bouton
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->valeur=(char*)malloc(strlen("Valider")+1);// On alloue la taille du texte
    sprintf(interface->gui[n]->valeur,"Valider");// On Dfinit le Texte
    interface->gui[n]->position.x=(interface->fenetre->w / 2)-(interface->gui[n]->image->w/2) ;
    interface->gui[n]->position.y=interface->gui[n-1]->position.y + 48;
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=160; // On ne rogne pas l'image
    interface->gui[n]->crop.h=32; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_OPTIONS; // Element du Menu Principal
    interface->gui[n]->flag=OPTIONS; // On passe au Menu Rejoindre
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // L'image sera libr  la fin

n++; /// ELEMENT 65 :  Bouton Retour au Menu
    interface->gui[n]->type=BOUTON; // Element de type Image
    sprintf(str,"%s%s",RESSOURCES_DIR,"bouton1.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image du bouton
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->valeur=(char*)malloc(strlen("Retour au Menu")+1);// On alloue la taille du texte
    sprintf(interface->gui[n]->valeur,"Retour au Menu");// On Dfinit le Texte
    interface->gui[n]->position.x=(interface->fenetre->w / 2)-(interface->gui[n]->image->w/2) ;
    interface->gui[n]->position.y=interface->gui[n-1]->position.y + 64;
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=160; // On ne rogne pas l'image
    interface->gui[n]->crop.h=32; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_OPTIONS; // Element du Menu Principal
    interface->gui[n]->flag=RETOUR; // On passe au Menu Rejoindre
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // L'image sera libre  la fin
/*
    MENU CREDITS
*/

n++; /// ELEMENT 66 :  Fond du Menu Options
    interface->gui[n]->type=IMAGE; // Element de type Image
    sprintf(str,"%s%s",RESSOURCES_DIR,"credits.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image du bouton
    interface->gui[n]->valeur=NULL;// Pas de Texte
    interface->gui[n]->position.x=interface->fenetre->w/2-(interface->gui[n]->image->w/2); // On Positionne le fond au milieu de la fenetre
    interface->gui[n]->position.y=224;// En haut
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=0; // On ne rogne pas l'image
    interface->gui[n]->crop.h=0; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_CREDITS; // Element du Menu Principal
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_IMAGE; // L'image sera libr  la fin

n++; /// ELEMENT 67 :  Bouton Retour au Menu
    interface->gui[n]->type=BOUTON; // Element de type Image
    sprintf(str,"%s%s",RESSOURCES_DIR,"bouton1.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image du bouton
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->valeur=(char*)malloc(strlen("Retour au Menu")+1);// On alloue la taille du texte
    sprintf(interface->gui[n]->valeur,"Retour au Menu");// On Dfinit le Texte
    interface->gui[n]->position.x=(interface->fenetre->w / 2)-(interface->gui[n]->image->w/2) ;
    interface->gui[n]->position.y=480;
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=160; // On ne rogne pas l'image
    interface->gui[n]->crop.h=32; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_CREDITS; // Element du Menu Principal
    interface->gui[n]->flag=RETOUR; // On passe au Menu Rejoindre
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // L'image sera libre  la fin

n++; /// ELEMENT 68 : POINTEUR SOURIS
    interface->gui[n]->type=IMAGE; // Element de type Texte
    sprintf(str,"%s%s",RESSOURCES_DIR,"curseur.png"); // On rcupre le chemin du curseur
    interface->gui[n]->image=IMG_Load(str);// On charge l'image
    interface->gui[n]->valeur=NULL; // On alloue la mmoire pour le texte
    interface->gui[n]->position.x=0; // Position en X du texte
    interface->gui[n]->position.y=0; // Position en Y du texte
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=24; // Pas de crop
    interface->gui[n]->crop.h=24; // Pas de crop
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=FENETRE; // Appartient au menu droulant du Type
    interface->gui[n]->flag=POINTEUR; // Pas d'action
    interface->gui[n]->free=FREE_IMAGE; // On libre le texte allou

    interface->pointeur.x = 0;
    interface->pointeur.y = 0;

/// On charge une musique d'intro
    sprintf(str,"%s%s",SOUNDS_DIR,"ouverture.ogg");
    interface->musique=Mix_LoadMUS(str);
    if(!interface->musique) {
        printf("Mix_LoadMUS(\"%s\"): %s\n",str, Mix_GetError());
        // this might be a critical error...
    }
// On la joue
    Mix_PlayMusic(interface->musique, 1);
}

// Supprime les donnes de l'interface
void liberer_interface(t_interface* interface) //dite le 25/02/2010  14:11 par Loc
{
    long n; // Compteur

    TTF_CloseFont(interface->font);// On supprime la police de caractre

    for (n=0;n<interface->gui_taille;n++) // Pour chaque element du GUI
    {
        if (interface->gui[n]->free & FREE_IMAGE) // Si on doit supprimer l'image
        {
            SDL_FreeSurface(interface->gui[n]->image); // On supprime l'image
        }

        if (interface->gui[n]->free & FREE_VALEUR)// Si on doit supprimer le texte
        {
            free(interface->gui[n]->valeur);  // On libre le texte
        }

        free(interface->gui[n]); // On libre ensuite l'element
    }
    Mix_FreeMusic(interface->musique); // ON libere la musique

    free(interface->gui); // On supprime enfin les pointeurs vers ces elements

    // la variable interface sera libr  la fin du main automatiquement
}

void liberer_affichage(SDL_Surface* fenetre)
{
    SDL_FreeSurface(fenetre);// On supprime la surface de la fenetre

    TTF_Quit(); // On quitte SDL_ttf
    SDL_Quit(); // On quitte la SDL
}
// Affiche l'interface
void afficher_interface(t_interface* interface)
{
    long n; // Compteur
    SDL_Rect position, crop; // Structures utilises pour le positionnement et le rognage
    SDL_Color couleur; //Contient la couleur du texte  afficher
    SDL_Surface * tmpsurface = NULL; // Surface temporaire
    char str[256]; // Chaine de caractre pour les champ de saisie

    for (n=0;n<interface->gui_taille;n++)
    {
        str[0]=0; // On efface la chaine de caractre
        // On paramtre la couleur du texte  NOIR
        couleur.r=0;
        couleur.g=0;
        couleur.b=0;

        actualiser_gui(n, interface);// On actualise l'element courant en fonction de son flag, ainsi que les donnes qu'il concerne

        if (interface->gui[n]->visible) // Si l'element est visible, on l'affiche
        {
            if (interface->gui[n]->type == TEXTE) // Si l'element est de type Texte
            {
                tmpsurface = TTF_RenderText_Blended(interface->font, interface->gui[n]->valeur, couleur); // On place le texte dans la surface temporaire
                SDL_BlitSurface(tmpsurface, 0, interface->fenetre, &interface->gui[n]->position); // On blitte le texte
                SDL_FreeSurface(tmpsurface); // On dtruit la surface temporaire pour une utilisation ultrieure
                /*
                Remarque: On pourrait utiliser le champ image pour la surface au lieu de tmpsurface, mais on pourrait imaginer ke le texte
                aurait un arrire plan color
                */
            }
            else if (interface->gui[n]->type == SAISIE)  // Si l'element est de type Saisie
            {

                sprintf(str,"%s   ",interface->gui[n]->valeur); // On place dans la chaine de caractre temporaire la valeur du champ

                if (interface->gui[n]->etat == ACTIF) // Si l'element est actif (selectionn)
                {
                    if((SDL_GetTicks()/500)%2) // Toutes les demi-secondes
                    {
                            sprintf(str,"%s|",interface->gui[n]->valeur); // On remplace la chaine de caractre pour y rajouter un curseur
                    }
                }

                tmpsurface = TTF_RenderText_Blended(interface->font, str , couleur);// On place le texte dans la surface temporaire


                position.x = interface->gui[n]->position.x + 2; // On laisse un marge de 2px  gauche
                position.y = interface->gui[n]->position.y + ((interface->gui[n]->crop.h - tmpsurface->h)/2); // On centre verticalement le texte dans le champ
                crop=interface->gui[n]->crop; // on rogne le texte  la taille du champ pour eviter qu'il dpasse

                if ((tmpsurface->w+2) > interface->gui[n]->crop.w) // Si le texte est plus large que le champ
                {
                    crop.x=tmpsurface->w-interface->gui[n]->crop.w+2; // On l'aligne sur la droite et non sur la gauche avec une marge de 2 px
                }


                SDL_BlitSurface(interface->gui[n]->image, &interface->gui[n]->crop, interface->fenetre, &interface->gui[n]->position); // On affiche le fond du champ
                SDL_BlitSurface(tmpsurface, &crop , interface->fenetre, &position);// Puis le texte (rogn) par dessus
                SDL_FreeSurface(tmpsurface); // On n'noublie pas de librer la mmoire de la surface temporaire
            }
            else if (interface->gui[n]->type == BOUTON || interface->gui[n]->type == SWITCH) // Si l'element est un bouton (switchable ou non)
            {
                if (interface->gui[n]->valeur) // si le bouton contient un texte
                {
                    tmpsurface = TTF_RenderText_Blended(interface->font, interface->gui[n]->valeur , couleur); // On place le texte dans la surface temporaire

                    if (interface->gui[n]->type == SWITCH) // Si l'element est un switch
                    {
                        // Alignement sur la gauche
                        position.x = interface->gui[n]->position.x + 16; // On garde une marge  gauche de 16px
                        position.y = interface->gui[n]->position.y + ((interface->gui[n]->crop.h - tmpsurface->h)/2); // On centre verticalement le texte dans le champ
                    }
                    else // Sinon
                    {
                        // Alignement centr
                        position.x = interface->gui[n]->position.x + ((interface->gui[n]->crop.w - tmpsurface->w)/2);// On centre horizontalement le texte dans le champ
                        position.y = interface->gui[n]->position.y + ((interface->gui[n]->crop.h - tmpsurface->h)/2);// On centre verticalement le texte dans le champ
                    }
                }

                if (interface->gui[n]->etat == ACTIF) // Si le bouton est actif (enfonc)
                {
                    interface->gui[n]->crop.y=2*interface->gui[n]->crop.h; // On prend la 3eme position dans l'image (Enfonce)
                    // On dplace le texte en diagonale (effet d'enfoncement)
                    position.x+=2; // 2 pixels vers la droite
                    position.y+=2; // 2 pixels vers le bas
                }
                else if (interface->gui[n]->etat == SURVOL) // Sinon si il est juste survol
                {
                    interface->gui[n]->crop.y=interface->gui[n]->crop.h; // On prend la 2eme position dans l'image (Highlighted - Eclaire)
                }
                else // Sinon
                {
                    interface->gui[n]->crop.y=0; // On prend la 1ere position dans l'image (Normale)
                }

                SDL_BlitSurface(interface->gui[n]->image, &interface->gui[n]->crop, interface->fenetre, &interface->gui[n]->position); // On affiche le bouton

                if (interface->gui[n]->valeur) // Toujours si ya un texte
                {
                    SDL_BlitSurface(tmpsurface, 0, interface->fenetre, &position); // On affiche le texte par dessus
                    SDL_FreeSurface(tmpsurface); // On n'noublie pas de librer la mmoire de la surface temporaire
                }
            }
            else if (interface->gui[n]->type == IMAGE) // SI l'element est juste une image
            {
                if (interface->gui[n]->crop.h && interface->gui[n]->crop.w) // Si l'on doit la rogner
                {
                    SDL_BlitSurface(interface->gui[n]->image, &interface->gui[n]->crop, interface->fenetre, &interface->gui[n]->position); // On l'affiche rogne
                }
                else // Sinon
                {
                    SDL_BlitSurface(interface->gui[n]->image, 0, interface->fenetre, &interface->gui[n]->position); // On l'affiche entire
                }
            }
        }
    }
}

// Actualise les elements et les donnes avant affichage
void actualiser_gui(long element,t_interface* interface)
{
    /*
    Remarque: Le switch est ger diffrement que le reste des elements dans la boucle d'evenements, car c'est un bouton ON/OFF,
    il peut tre actif meme si un autre element est selectionn, un clic inverse donc l'activation de ce type d'element
    */
    if (interface->gui[element]->type!=SWITCH)// Si l'element n'est donc pas un switch
    {
        if (interface->gui[element] == interface->gui_actif) // Si l'element est selectionn
        {
            interface->gui[element]->etat=ACTIF; // Alors il est actif
        }
        else if (interface->pointeur.x>=interface->gui[element]->position.x
        && interface->pointeur.x < interface->gui[element]->position.x+interface->gui[element]->crop.w
        && interface->pointeur.y>=interface->gui[element]->position.y
        && interface->pointeur.y < interface->gui[element]->position.y+interface->gui[element]->crop.h
        ) // Si le pointeur est situ entre son coin haut gauche et son coin bas droit
        {
            interface->gui[element]->etat=SURVOL; // Alors il est survol
        }
        else // Sinon
        {
            interface->gui[element]->etat=INACTIF; // Il est inactif
        }
    }
    else // Sinon, si l'element est un switch
    {
        if (interface->gui[element]->etat!=ACTIF) // ET qu'il n'est pas actif, cd, sur la position OFF
        {
            if (interface->pointeur.x>=interface->gui[element]->position.x
            && interface->pointeur.x < interface->gui[element]->position.x+interface->gui[element]->crop.w
            && interface->pointeur.y>=interface->gui[element]->position.y
            && interface->pointeur.y < interface->gui[element]->position.y+interface->gui[element]->crop.h
            ) // Si le pointeur est situ entre son coin haut gauche et son coin bas droit
            {
                interface->gui[element]->etat=SURVOL; // ALors il est survol
            }
            else
            {
                interface->gui[element]->etat=INACTIF; // Sinon, il est juste en position OFF
            }
        }
    }

    /* Remarque:
    Le flag determine comment reagit un element, les donnes qu'il doit actualiser, ce qu'il stocke, et quel aspect
    il doit avoir en fonction des donnes qui lui sont exterieurs
    */
    switch(interface->gui[element]->flag) // On actualise diffrement un element en fonction de son flag
    {
        case PLEIN_ECRAN:
            if (interface->gui[element]->etat==ACTIF)
            {
                interface->options.plein_ecran=1;
            }
            else
            {
                interface->options.plein_ecran=0;
            }
            break;
        case POINTEUR:
            if (interface->mousefocus)
            {
                interface->gui[element]->visible=1;
                interface->gui[element]->position=interface->pointeur;
                interface->gui[element]->crop.x=interface->clic*32;
            }
            else
            {
                interface->gui[element]->visible=0;
            }
            break;
        default: // Si l'element a un flag qui ne requiert aucune actualisation spcifique
        // On ne fait rien (et on vite un avertissement du compilateur)
            break;
    }
}

 // Effectuer l'action d'un flag
void effectuer_gui(enum gui_flag flag,t_interface* interface)
{
    char str[255];
    long element;
    /* Remarque :
    Lorsqu'un lement est "valid", par la touche entre si c'est une saisie, ou un clic pour un bouton,
    alors on doit faire l'action correpondnate, et dsigne par le flag de l'element
    */
    switch(flag)// En fonction du flag
    {
        case CONFIGURER_REJOINDRE:
            afficher_groupe(interface,MENU_REJOINDRE);
            break;
        case REJOINDRE:
            sprintf(str,EXEC_CMD,"client.exe");
            // Parametrage de l'argument du Nom de la Map
            element=obtenir_element(interface,REJOINDRE_PSEUDO);
            if(element!=-1)
            {
                if (strlen(interface->gui[element]->valeur))
                {
                    strcat(str," -pseudo=");
                    strcat(str,interface->gui[element]->valeur);
                }
            }

            element=obtenir_element(interface,REJOINDRE_ADRESSE);
            if(element!=-1)
            {
                if (strlen(interface->gui[element]->valeur))
                {
                    strcat(str," -adresse=");
                    strcat(str,interface->gui[element]->valeur);
                }
            }

            element=obtenir_element(interface,REJOINDRE_PORT);
            if(element!=-1)
            {
                if (strlen(interface->gui[element]->valeur))
                {
                    strcat(str," -port=");
                    strcat(str,interface->gui[element]->valeur);
                }
            }

            if (interface->options.plein_ecran)
            {
                strcat(str," -f");
            }

            sprintf(str,"%s -volume_son=%ld",str,interface->options.volume_son);
            sprintf(str,"%s -volume_musique=%ld",str,interface->options.volume_musique);

            system(str);
            interface->continuer=0;
            break;
        case CONFIGURER_SERVEUR:
            afficher_groupe(interface,MENU_SERVEUR);
            break;
        case SERVEUR:
            sprintf(str,EXEC_CMD,"serveur.exe");
            // Parametrage de l'argument du Nom de la Map
            element=obtenir_element(interface,PARTIE_NOM);
            if(element!=-1)
            {
                if (strlen(interface->gui[element]->valeur))
                {
                    strcat(str," -charger=");
                    strcat(str,interface->gui[element]->valeur);
                }
                else
                {
                    element=obtenir_element(interface,PARTIE_MAP);
                    if(element!=-1)
                    {
                        if (strlen(interface->gui[element]->valeur))
                        {
                            strcat(str," -map=");
                            strcat(str,interface->gui[element]->valeur);
                        }
                    }

                    element=obtenir_element(interface,PARTIE_DIST_INC);
                    if(element!=-1)
                    {
                        if (strlen(interface->gui[element]->valeur))
                        {
                            strcat(str," -dist_inc=");
                            strcat(str,interface->gui[element]->valeur);
                        }
                    }

                    element=obtenir_element(interface,PARTIE_DIST_VIS);
                    if(element!=-1)
                    {
                        if (strlen(interface->gui[element]->valeur))
                        {
                            strcat(str," -dist_vis=");
                            strcat(str,interface->gui[element]->valeur);
                        }
                    }

                    element=obtenir_element(interface,PARTIE_CHEVALIER);
                    if(element!=-1)
                    {
                        if (strlen(interface->gui[element]->valeur))
                        {
                            strcat(str," -chevalier=");
                            strcat(str,interface->gui[element]->valeur);
                        }
                    }

                    element=obtenir_element(interface,PARTIE_PECORE);
                    if(element!=-1)
                    {
                        if (strlen(interface->gui[element]->valeur))
                        {
                            strcat(str," -pecore=");
                            strcat(str,interface->gui[element]->valeur);
                        }
                    }

                    element=obtenir_element(interface,PARTIE_ECLAIREUR);
                    if(element!=-1)
                    {
                        if (strlen(interface->gui[element]->valeur))
                        {
                            strcat(str," -eclaireur=");
                            strcat(str,interface->gui[element]->valeur);
                        }
                    }
                }
            }

            strcat(str," -lancer");
            strcat(str," -autokill");
            system(str);

            str[0]=0;
            sprintf(str,EXEC_CMD,"client.exe");
            strcat(str," -pseudo=");
            strcat(str,interface->options.pseudo);
            if (interface->options.plein_ecran)
            {
                strcat(str," -f");
            }
            sprintf(str,"%s -volume_son=%ld",str,interface->options.volume_son);
            sprintf(str,"%s -volume_musique=%ld",str,interface->options.volume_musique);
            system(str);

            interface->continuer=0;
            break;
        case CONFIGURER_EDITEUR:
            afficher_groupe(interface,MENU_EDITEUR);
            break;
        case EDITEUR:
            sprintf(str,EXEC_CMD,"editeur.exe");
            // Parametrage de l'argument du Nom de la Map
            element=obtenir_element(interface,MAP_NOM);
            if(element!=-1)
            {
                if (strlen(interface->gui[element]->valeur))
                {
                    strcat(str," -map=");
                    strcat(str,interface->gui[element]->valeur);
                }
            }

            element=obtenir_element(interface,MAP_TILESET);
            if(element!=-1)
            {
                if (strlen(interface->gui[element]->valeur))
                {
                    strcat(str," -tileset=");
                    strcat(str,interface->gui[element]->valeur);
                }
            }

            element=obtenir_element(interface,MAP_LARGEUR);
            if(element!=-1)
            {
                if (strlen(interface->gui[element]->valeur))
                {
                    strcat(str," -largeur=");
                    strcat(str,interface->gui[element]->valeur);
                }
            }

            element=obtenir_element(interface,MAP_HAUTEUR);
            if(element!=-1)
            {
                if (strlen(interface->gui[element]->valeur))
                {
                    strcat(str," -hauteur=");
                    strcat(str,interface->gui[element]->valeur);
                }
            }

            system(str);
            interface->continuer=0;
            break;
        case CONFIGURER_OPTIONS:
            afficher_groupe(interface,MENU_OPTIONS);
            break;
        case OPTIONS:
            sauvegarder_config(interface);
            break;
        case CREDITS:
            afficher_groupe(interface,MENU_CREDITS);
            break;
        case RETOUR:
            afficher_groupe(interface,MENU_PRINCIPAL);
            break;
        case QUITTER:
            interface->continuer=0;
            break;
        default:
            break;
    }
    interface->gui_actif=0; // On dsactive ensuite l'element valid (ou l'element actuellement activ)
}

long obtenir_element(t_interface *interface,enum gui_flag flag)
{
    long n,element=-1;

    for (n=0; n<interface->gui_taille;n++)
    {
        if (interface->gui[n]->flag==flag)
        {
            element=n;;

        }
    }
    return element;
}


/// Attention, fonctionnement diffrent des autres programmes
// Affiche le groupe d'elements prcis, et masque les autres
void afficher_groupe(t_interface *interface, enum gui_groupe groupe)
{
    long n;

    for (n=0; n<interface->gui_taille;n++)
    {
        if (interface->gui[n]->groupe==groupe)
        {
            interface->gui[n]->visible=1;
        }
        else if (interface->gui[n]->groupe!=0)
        {
            interface->gui[n]->visible=0;
        }
    }
}

void afficher_message(t_interface *interface, char *txt, long rouge, long vert, long bleu)
{
    long message_element;
    SDL_Surface* mess;

    message_element=obtenir_element(interface,MESSAGE);


    if (message_element!=-1)
    {

        mess=interface->gui[message_element]->image;

        SDL_Surface *texte; //Contient le texte sous forme d'image  copier sur la destination (resul)
        SDL_Rect position; //Contient les paramtres de position pour les diffrents affichages  effectuer
        SDL_Color couleur; //Contient la couleur du texte  afficher

        //Convertit le texte en une image  coller sur ecran
        couleur.r = rouge;
        couleur.g = vert;
        couleur.b = bleu;
        texte = TTF_RenderText_Blended(interface->font, txt, couleur); //crit le texte
        //Scroll
        interface->gui[message_element]->image = SDL_CreateRGBSurface(mess->flags, mess->w, mess->h, mess->format->BitsPerPixel, mess->format->Rmask, mess->format->Gmask, mess->format->Bmask, mess->format->Amask);
        SDL_FillRect(interface->gui[message_element]->image, NULL, SDL_MapRGBA(mess->format, 0, 0, 0, 0));
        SDL_SetAlpha(mess, 0,255); // On desactive le SRCALPHA pour copier les donnes RGBA, et remplacer l'alpha de la destination
        SDL_SetAlpha(texte, 0,255); // On desactive le SRCALPHA pour copier les donnes RGBA, et remplacer l'alpha de la destination

        position.x = 0;
        position.y = texte->h;
        position.w = mess->w;
        position.h = mess->h - texte->h;
        SDL_BlitSurface(mess, &position, interface->gui[message_element]->image, NULL);
        //Affichage du nouveau texte
        position.x = 0;
        position.y = mess->h - texte->h;
        SDL_BlitSurface(texte, NULL, interface->gui[message_element]->image, &position);
        //On efface l'image du texte
        SDL_FreeSurface(texte);
        SDL_FreeSurface(mess);

        sprintf(interface->gui[message_element]->valeur,"%ld",(long)SDL_GetTicks());
    }
    else
    {
        printf("Erreur lors de l'obtention d'un element du GUI\n");
    }
}

long obtenir_fps(long incrementer)
{
    static long dernier_f=0,frames=0,dernier_temps=0;

    if (dernier_temps-SDL_GetTicks()>= 1000)
    {
        dernier_f=frames;
        frames=0;
        dernier_temps+=1000;
    }

    frames+=incrementer;

    return dernier_f;
}

void charger_config(t_interface *interface)
{
    FILE* fichier=NULL; // Pointeur sur le fichier .map  charger
    long n;
    char c;
    char *str;
    str=(char*)malloc(SAISIE_MAX+1);
    str[0]=0;

    char pseudos[11][32]={
    "Roi Arthur",
    "Lancelot",
    "Perceval",
    "Karadoc",
    "Lodagan",
    "Bohort",
    "Kadoc",
    "Pre Blaise",
    "Merlin",
    "Gauvain",
    "Yvain"
    };

    srand( time(NULL));
    interface->options.pseudo=(char *)malloc(SAISIE_MAX+1);
    strcpy(interface->options.pseudo,pseudos[rand()%11]);

    interface->options.volume_son=128;
    interface->options.volume_musique=128;
    interface->options.plein_ecran=0;


    fichier=fopen("kaaptur.conf","rb"); // On ouvre le fichier en LECTURE BINAIRE SEULE

    if (fichier) // Si un fichier a pu tre ouvert alors On charge ^^
    {
        while (!feof(fichier))
        {
            n=0;// On initialise le compteur d'indice
            str[0]=0;
            // Boucle Do...While pour capturer le nom du fichier
            do
            {
                c=fgetc(fichier); // On rcupre le caractre

                if (feof(fichier))
                {
                    c=';';
                }

                if (c!='\n' && c!='\r' && c!=';')
                {
                    if (n<=SAISIE_MAX)
                    {
                        str[n]=c; // Et on le rajoute au nom du fichier
                    }
                    n++; // ON n'oublie pas d'incrmenter l'indice
                }

            }while(c!=';'); // Le caractre EOT permet de dfinir la fin de la dclaration

            str[n]=0;

            if(comparer_commande("pseudo=", str)) //Si on demande de changer le port
            {
                sscanf(str, "pseudo=%s", interface->options.pseudo);
            }
            else if(comparer_commande("volume_son=", str)) //Si on demande de changer le port
            {
                sscanf(str, "volume_son=%ld", &interface->options.volume_son);
                if (interface->options.volume_son > 128) {interface->options.volume_son=128;}
            }
            else if(comparer_commande("volume_musique=", str)) //Si on demande de changer le port
            {
                sscanf(str, "volume_musique=%ld", &interface->options.volume_musique);
                if (interface->options.volume_musique > 128) {interface->options.volume_musique=128;}
            }
            else if(comparer_commande("fullscreen=", str)) //Si on demande de changer le port
            {
                sscanf(str, "fullscreen=%ld", &interface->options.plein_ecran);
            }
        }

        fclose(fichier);
    }

}

void sauvegarder_config(t_interface *interface)
{
    FILE* fichier=NULL; // Pointeur sur le fichier .map  charger
    fichier=fopen("kaaptur.conf","wb"); // On ouvre le fichier en LECTURE BINAIRE SEULE


    long element;

    if (fichier) // Si un fichier a pu tre ouvert alors On charge ^^
    {
        element=obtenir_element(interface,PSEUDO);
        if (strlen(interface->gui[element]->valeur))
        {
            fprintf(fichier,"pseudo=%s;\n",interface->gui[element]->valeur);
        }

        element=obtenir_element(interface,VOLUME_SON);
        if (strlen(interface->gui[element]->valeur))
        {
            fprintf(fichier,"volume_son=%s;\n",interface->gui[element]->valeur);
        }

        element=obtenir_element(interface,VOLUME_MUSIQUE);
        if (strlen(interface->gui[element]->valeur))
        {
            fprintf(fichier,"volume_musique=%s;\n",interface->gui[element]->valeur);
        }

        fprintf(fichier,"fullscreen=%ld;\n",interface->options.plein_ecran);

        fclose(fichier);
    }

    charger_config(interface);
}


// Renvoie le pixel d'une surface
Uint32 GetPixel(SDL_Surface* surface, long x, long y)
{
    long bpp = surface->format->BytesPerPixel; // Octets par pixel
    /*  p est l'addresse du pixel que l'on veut rcuprer */
    Uint8 *p = (Uint8 *)surface->pixels + y * surface->pitch + x * bpp;

    switch(bpp)
    {
    case 1:
        return *p;

    case 2:
        return *(Uint16 *)p;

    case 3:
        if(SDL_BYTEORDER == SDL_BIG_ENDIAN)
            return p[0] << 16 | p[1] << 8 | p[2];
        else
            return p[0] | p[1] << 8 | p[2] << 16;

    case 4:
        return *(Uint32 *)p;

    default:
        return 0;  /* Ne devrait pas arriver, mais supprime les avertissements du compilateur */
    }
}

long comparer_commande(char *cmd, char *str)
{
    long i; //Compteur pour la boucle

    if(strlen(cmd) > strlen(str)) {return 0;} //Si la commande est plus longue que la saisie alors ce n'est pas cette commande qui est appele
    else
    {
        //Pour chaque caractre de la commande
        i = 0;
        while(cmd[i] != 0)
        {
            if(cmd[i] != str[i]) {return 0;} //S'il diffre de la saisie alors ce n'est pas cette commande qui est appele
            else i++;
        }
        return 1; //Si tous les caractres sont identiques, on a trouv la commande appele
    }
}
